# Installation Guide - Zorg Subtitle Premiere Pro Extension

## Quick Start

### Prerequisites

- Adobe Premiere Pro CC 2018 or later
- A Zorg Subtitle account ([sign up here](https://zorgsubtitle.com))
- API key from your dashboard

### Step 1: Install the Extension

#### macOS

1. Open Terminal
2. Run the following commands:

```bash
# Navigate to the Adobe CEP extensions folder
cd "/Library/Application Support/Adobe/CEP/extensions"

# Create the directory if it doesn't exist
sudo mkdir -p "/Library/Application Support/Adobe/CEP/extensions"

# Copy the extension
sudo cp -r /path/to/premiere-extension "/Library/Application Support/Adobe/CEP/extensions/ZorgSubtitle"

# Fix permissions
sudo chmod -R 755 "/Library/Application Support/Adobe/CEP/extensions/ZorgSubtitle"
```

#### Windows

1. Open Command Prompt as Administrator
2. Run the following commands:

```cmd
# Navigate to the Adobe CEP extensions folder
cd "C:\Program Files (x86)\Common Files\Adobe\CEP\extensions"

# Copy the extension
xcopy /E /I "C:\path\to\premiere-extension" "C:\Program Files (x86)\Common Files\Adobe\CEP\extensions\ZorgSubtitle"
```

### Step 2: Enable Unsigned Extensions (Development Mode)

#### macOS

1. Open Terminal
2. Create the debug mode file:

```bash
# For CEP 11 (Premiere Pro 2021+)
defaults write com.adobe.CSXS.11 PlayerDebugMode 1

# For CEP 10 (Premiere Pro 2020)
defaults write com.adobe.CSXS.10 PlayerDebugMode 1

# For CEP 9 (Premiere Pro 2019)
defaults write com.adobe.CSXS.9 PlayerDebugMode 1
```

#### Windows

1. Open Registry Editor (regedit.exe) as Administrator
2. Navigate to `HKEY_CURRENT_USER\Software\Adobe\CSXS.11`
   - If the key doesn't exist, create it
3. Create a new String Value named `PlayerDebugMode` with value `1`

**Important:** Repeat for CSXS.10 and CSXS.9 if using older versions

### Step 3: Restart Premiere Pro

1. Completely quit Premiere Pro (not just close the project)
2. Relaunch Premiere Pro

### Step 4: Open the Extension

1. In Premiere Pro, go to **Window** > **Extensions**
2. Click on **Zorg Subtitle**
3. The extension panel will appear

## Getting Your API Key

1. Visit [https://zorgsubtitle.com/dashboard/api-keys](https://zorgsubtitle.com/dashboard/api-keys)
2. Click **Create API Key**
3. Give it a name (e.g., "Premiere Pro Extension")
4. Select the following scopes:
   - `read:videos`
   - `write:videos`
   - `read:subtitles`
   - `write:subtitles`
5. Click **Create**
6. Copy the API key (it starts with `zs_live_...`)

**Important:** Save this key somewhere safe! You won't be able to see it again.

## First-Time Setup

1. Open the Zorg Subtitle extension in Premiere Pro
2. Paste your API key in the input field
3. Click **Connect**
4. Your account information will be displayed

## Troubleshooting

### Extension doesn't appear in the menu

**Solution:**
1. Verify the extension folder is in the correct location
2. Check that debug mode is enabled (see Step 2)
3. Make sure you restarted Premiere Pro completely
4. Check the extension folder permissions (should be readable)

### "PlayerDebugMode" not working on macOS

**Solution:**
Try the alternative method:
```bash
# Create the preference file manually
sudo nano ~/Library/Preferences/com.adobe.CSXS.11.plist
```

Add:
```xml
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>PlayerDebugMode</key>
    <string>1</string>
</dict>
</plist>
```

### Extension shows "EvalScript error"

**Solution:**
1. Make sure the `host/index.jsx` file is present
2. Check that the manifest.xml points to the correct paths
3. Verify Premiere Pro has read permissions for the extension folder

### Connection fails

**Solution:**
1. Verify your API key is correct (starts with `zs_`)
2. Check your internet connection
3. Make sure your Zorg Subtitle account is active
4. Verify the API key has the correct scopes

### Export fails

**Solution:**
1. Make sure you have an active sequence selected
2. Check available disk space (exports are temporary)
3. Try selecting a lower quality export preset
4. Check Premiere Pro's temp folder permissions

### Upload timeout

**Solution:**
1. Large files may take longer - be patient
2. Check your internet connection speed
3. Consider using the "Medium" quality preset for faster exports
4. Maximum file size is 2GB

## File Locations

### Extension Directory
- **macOS**: `/Library/Application Support/Adobe/CEP/extensions/ZorgSubtitle/`
- **Windows**: `C:\Program Files (x86)\Common Files\Adobe\CEP\extensions\ZorgSubtitle\`

### Temporary Export Files
- **macOS**: `/var/folders/*/T/ZorgSubtitle/`
- **Windows**: `C:\Users\[Username]\AppData\Local\Temp\ZorgSubtitle\`

### Debug Logs
- **macOS**: `~/Library/Logs/CSXS/`
- **Windows**: `C:\Users\[Username]\AppData\Local\Temp\csxs\`

## Uninstallation

### macOS
```bash
sudo rm -rf "/Library/Application Support/Adobe/CEP/extensions/ZorgSubtitle"
```

### Windows
```cmd
rd /s "C:\Program Files (x86)\Common Files\Adobe\CEP\extensions\ZorgSubtitle"
```

## Production Installation (Coming Soon)

A signed `.zxp` package will be available for easier installation via:
- Adobe Exchange
- ZXP Installer
- Anastasiy's Extension Manager

## Support

If you encounter issues:

1. Check the debug logs (see File Locations above)
2. Visit our [documentation](https://docs.zorgsubtitle.com)
3. Contact support at support@zorgsubtitle.com
4. Report bugs at [GitHub Issues](https://github.com/zorgspace/zorg-subtle/issues)

## Advanced: Building ZXP Package

To create a signed ZXP package for distribution:

1. Install the ZXPSignCmd tool
2. Generate a self-signed certificate:
   ```bash
   ZXPSignCmd -selfSignedCert US CA "Zorg Space" "Zorg Subtitle" password certificate.p12
   ```
3. Sign the extension:
   ```bash
   ZXPSignCmd -sign premiere-extension ZorgSubtitle.zxp certificate.p12 password -tsa http://timestamp.digicert.com
   ```

## Version Information

- **Extension Version**: 1.0.0
- **CEP Version**: 11.0
- **Minimum Premiere Pro**: CC 2018 (v12.0)
- **Tested Up To**: Premiere Pro 2024 (v24.0)

---

© 2025 Zorg Space. All rights reserved.
