# Zorg Subtitle - Adobe Premiere Pro Extension

AI-powered subtitle generation directly within Adobe Premiere Pro.

## Overview

The Zorg Subtitle extension integrates seamlessly with Adobe Premiere Pro, allowing you to:

- Export video sequences directly from Premiere Pro
- Generate AI-powered subtitles using OpenAI Whisper
- Translate subtitles into 100+ languages
- Import subtitles back into your timeline

## Features

- **One-Click Export**: Export your active sequence without leaving Premiere Pro
- **AI Transcription**: Automatic speech recognition using state-of-the-art AI
- **Multi-Language Support**: Auto-detect or specify the source language
- **Translation**: Translate subtitles to any target language
- **Timeline Import**: Automatically import subtitles as SRT files into your timeline
- **Credit Tracking**: View remaining credits and subscription status
- **Secure API Authentication**: API key-based authentication

## Prerequisites

- Adobe Premiere Pro CC 2018 or later
- Active Zorg Subtitle account with API access
- Internet connection

## Installation

### Method 1: Manual Installation (Development)

1. **Locate your CEP extensions folder**:
   - **Windows**: `C:\Program Files (x86)\Common Files\Adobe\CEP\extensions\`
   - **macOS**: `/Library/Application Support/Adobe/CEP/extensions/`

2. **Copy the extension folder**:
   ```bash
   cp -r premiere-extension /Library/Application\ Support/Adobe/CEP/extensions/ZorgSubtitle
   ```

3. **Enable debug mode** (for development):

   Create/edit the following file:
   - **Windows**: `C:\Users\[Username]\AppData\Roaming\Adobe\CEP\extensions\CSXS.11\PlayerDebugMode`
   - **macOS**: `~/Library/Preferences/com.adobe.CSXS.11.plist`

   Add the content:
   ```
   1
   ```

4. **Restart Premiere Pro**

### Method 2: ZXP Installer (Production)

1. Download the `.zxp` package from releases
2. Install using [ZXP Installer](https://aescripts.com/learn/zxp-installer/) or Anastasiy's Extension Manager
3. Restart Premiere Pro

## Getting Started

### 1. Get Your API Key

1. Visit [Zorg Subtitle Dashboard](https://zorgsubtitle.com/dashboard/api-keys)
2. Create a new API key with the following scopes:
   - `read:videos`
   - `write:videos`
   - `read:subtitles`
   - `write:subtitles`
3. Copy the API key (starts with `zs_live_...`)

### 2. Launch the Extension

1. Open Adobe Premiere Pro
2. Go to **Window** > **Extensions** > **Zorg Subtitle**
3. The extension panel will appear

### 3. Authenticate

1. Paste your API key into the input field
2. Click **Connect**
3. The extension will verify your credentials and display your account info

## Usage Workflow

### Step 1: Select Your Sequence

1. Open the sequence you want to subtitle in Premiere Pro
2. Make it the active sequence (click on it)
3. In the extension, click **Get Active Sequence**
4. The sequence information will be displayed

### Step 2: Export & Upload

1. Choose the export quality:
   - **Medium**: Faster export, lower file size
   - **High**: Better quality (recommended)
2. Click **Export & Upload Video**
3. Wait for the export and upload to complete
4. A progress bar will show the current status

### Step 3: Generate Subtitles

1. Select the source language or choose **Auto-detect**
2. Click **Generate Subtitles**
3. The transcription will start (typically takes 1-2 minutes per minute of video)
4. Status updates will be shown in the extension

### Step 4: Translate (Optional)

1. If you want to translate to another language, select the target language
2. Click **Translate Subtitles**
3. The translation will be completed

### Step 5: Import to Timeline

1. Click **Import Subtitles to Timeline**
2. The subtitles will be imported as an SRT file
3. They will appear on the top video track
4. You can now style and position them as needed

## API Integration Details

The extension uses the Zorg Subtitle REST API v1:

### Endpoints Used

- `GET /api/v1/account` - Fetch account information and credits
- `POST /api/v1/videos` - Upload video for processing
- `GET /api/v1/videos/{id}` - Check video processing status
- `POST /api/v1/videos/{id}/transcribe` - Start transcription
- `POST /api/v1/videos/{id}/translate` - Translate subtitles
- `GET /api/v1/videos/{id}/subtitles` - Fetch generated subtitles

### Authentication

All API requests use Bearer token authentication:

```
Authorization: Bearer zs_live_...
```

### Rate Limits

- 60 requests per minute (general)
- 10 video uploads per minute
- 5 transcription requests per minute

## Troubleshooting

### Extension doesn't appear in Premiere Pro

1. Verify the extension is in the correct folder
2. Enable debug mode (see installation instructions)
3. Check the Premiere Pro version (CC 2018+)
4. Restart Premiere Pro completely

### Export fails

1. Make sure you have an active sequence selected
2. Check disk space in your temp folder
3. Verify Premiere Pro has write permissions
4. Try a lower quality export preset

### Upload fails

1. Check your internet connection
2. Verify the API key is valid and has correct scopes
3. Check if you have enough credits
4. File size limit is 2GB

### Transcription timeout

1. Longer videos take more time (typically 1-2 min per video minute)
2. Check your internet connection
3. Verify the video was uploaded successfully
4. Contact support if the issue persists

### Import fails

1. Make sure transcription completed successfully
2. Verify you have at least one video track in your sequence
3. Check Premiere Pro permissions for file import

### Debug Logs

ExtendScript logs can be viewed in:
- **macOS**: `/Users/[Username]/Library/Logs/CSXS/`
- **Windows**: `C:\Users\[Username]\AppData\Local\Temp\csxs\`

## Credits & Pricing

- **Transcription**: 1 credit per minute of video
- **Translation**: 1 credit per minute of video
- **Export**: Free

Check your subscription plan at [zorgsubtitle.com/pricing](https://zorgsubtitle.com/pricing)

## Development

### Building from Source

The extension consists of three main parts:

1. **CEP Manifest** (`CSXS/manifest.xml`) - Extension configuration
2. **Client** (`client/`) - HTML/CSS/JavaScript UI
3. **Host** (`host/`) - ExtendScript for Premiere Pro integration

### File Structure

```
premiere-extension/
├── CSXS/
│   ├── manifest.xml          # Extension manifest
│   └── .debug                # Debug configuration
├── client/
│   ├── index.html            # Main UI
│   ├── styles.css            # Styling
│   ├── app.js                # Application logic
│   ├── lib/
│   │   └── CSInterface.js    # Adobe CEP library
│   └── assets/
│       ├── icon-light.png
│       └── icon-dark.png
└── host/
    ├── index.jsx             # ExtendScript functions
    └── json2.js              # JSON parser for ExtendScript
```

### Technologies Used

- **CEP (Common Extensibility Platform)**: Adobe's framework for extensions
- **ExtendScript**: JavaScript variant for Adobe applications
- **CSInterface**: Bridge between HTML and ExtendScript
- **Fetch API**: For REST API communication
- **Node.js**: Enabled via CEF for file operations

## Support

- **Documentation**: [docs.zorgsubtitle.com](https://docs.zorgsubtitle.com)
- **API Reference**: [zorgsubtitle.com/docs/API.md](https://zorgsubtitle.com/docs/API.md)
- **Issues**: [github.com/zorgspace/zorg-subtle/issues](https://github.com/zorgspace/zorg-subtle/issues)
- **Email**: support@zorgsubtitle.com

## License

© 2025 Zorg Space. All rights reserved.

## Version History

### v1.0.0 (2025-12-27)
- Initial release
- Video export and upload
- AI transcription with Whisper
- Multi-language translation
- Timeline import
- API key authentication
